<?php
if ( !defined( 'ABSPATH' ) ) exit;

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );
         
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'hello-elementor','hello-elementor','hello-elementor-theme-style','hello-elementor-header-footer' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );

function add_google_site_verification() {
    echo '<meta name="google-site-verification" content="ar6-NWDoGW3hrf2d-EbYuFqU8UhA69uXDNhoWshgGxQ" />' . "\n";
}
add_action('wp_head', 'add_google_site_verification');

add_filter('use_block_editor_for_post', '__return_false', 10);
add_filter('use_widgets_block_editor', '__return_false');

// function mainenqu()
// {
// 	wp_enqueue_script('jquery-script', 'https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js', array('jquery'), '', true);
// 	wp_enqueue_style('bootstrapCss', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.0.2/css/bootstrap.min.css');
// 	wp_enqueue_script('bootstrapJs', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.0.2/js/bootstrap.min.js', array('jquery'), '', true);
//     wp_enqueue_style('fontsawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css');
// }
// add_action('wp_enqueue_scripts', 'mainenqu');

function blog_loop()
{
    $arg = array(
        'post_type' => 'post',
        'posts_per_page' => -1,
    );
    $blogPost = new WP_Query($arg);

    ?>
<div class="card-sec">
    <?php if ($blogPost->have_posts()): ?>
    <?php while ($blogPost->have_posts()): ?>
    <?php $blogPost->the_post();
                    $url = wp_get_attachment_url(get_post_thumbnail_id($blogPost->ID)); ?>
    <div class="card">
        <div class="card-img">
            <img src="<?php echo $url ?>">
        </div>
        <div class="card-content">
            <div class="card-blog-date">
                <h6>
                    <?php the_time('j F, Y'); ?>
                </h6>
            </div>
            <?php $title = get_the_title(); ?>
            <h2>
                <?php echo substr($title, 0, 58); ?>
            </h2>
            <?php $content = get_the_content(); ?>
            <div class="post-content">
                <p>
                    <?php echo substr($content, 0, 80); ?>
                </p>
            </div>
            <a href="<?php the_permalink(); ?>" class="btn ban-btn">Read More</a>
        </div>
    </div>
    <?php endwhile; ?>
    <?php endif; ?>
</div>
<?php
    wp_reset_postdata();
}
add_shortcode('blogAll', 'blog_loop');


add_filter( 'wpseo_sitemap_index_links', function( $sitemap_index ) {
    foreach ( $sitemap_index as $key => $sitemap ) {
        if (
            strpos( $sitemap['loc'], 'author-sitemap.xml' ) !== false ||
            strpos( $sitemap['loc'], 'elementor-hf-sitemap.xml' ) !== false
        ) {
            unset( $sitemap_index[$key] );
        }
    }
    return $sitemap_index;
});